/* Services performed by FREESCALE in this matter are performed AS IS 
 * and without any warranty.  CUSTOMER  retains the final decision 
 * relative to the total design and functionality of the end product. 
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER for 
 * the success of this project. FREESCALE disclaims all warranties, 
 * express, implied or statutory including, but not limited to, implied 
 * warranty of merchantability or fitness for a particular purpose on any 
 * hardware, software ore advise supplied  to the project by FREESCALE, 
 * and or any product resulting from FREESCALE services . In no event shall 
 * FREESCALE be liable for incidental or consequential damages arising out 
 * of this agreement. CUSTOMER agrees to hold FREESCALE harmless against any 
 * and all claims demands or actions by anyone on account of any damage, or 
 * injury, whether commercial, contractual, or tortuous, rising directly or 
 * indirectly as a result of the advise or assistance supplied CUSTOMER in 
 * connection with product, services or goods supplied under this Agreement. 
 **/

/**
  \mainpage 
  
  \n Copyright (c) 2005 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief 
  
  \author   	Freescale Semiconductor
  \author
  \author   	Guadalajara Applications Laboratory RTAC Americas
  
  \version		v.1.0
  \date			12/22/2005
  
  Use of FFT and Inverse FFT DSP functions in ColdFire.
  
*/

#include <stdio.h>
#include "mcf5282.h"
/** Header of FFT and Inverse FFT DSP functions */
#include "fft.h"

/** Number of samples */
#define N 1024

/** Comment it if you don't want the 32 bits FFT */
#define bits32
/** Comment it if you don't want the 16 bits FFT */
#define bits16


int main()
{
	uint32 i;
	
	float afInput[N] =
	{
		#include "fft_sine_input.h"
	};

	int32 alReX32[N] = {0};
	int32 alImX32[N] = {0};

	int16 alReX16[N] = {0};
	int16 alImX16[N] = {0};

	#ifdef __EMAC
		printf("\n\r\n\r\n\rFFT test in eMAC\n\r");
	#else
		printf("\n\r\n\r\n\rFFT test in MAC\n\r");
	#endif
		

	#ifdef bits32    /* FFT in eMAC 32 bits */

	printf("Input signal 32 bits \n\r\n\r");
	
	for(i = 0; i < N; i++)
	{
		alReX32[i] = FRAC32(afInput[i]);
		printf("%d \n\r",alReX32[i]);
		alReX32[i] /= (N/2);  /* This operation is needed because the output is N/2 bigger */
	}

	fft32(alReX32,alImX32);

	printf("\n\rOutput FFT signal 32 bits \n\r\n\r");

	for(i = 0; i < N/2; i++)
	{
		printf("%d \t %d\n\r",alReX32[i],alImX32[i]);
	}
	
	
	for(i = 0; i < N/2; i++)
	{
		/* This operation is needed to reduce the input peaks and prevent the saturation of the INV FFT */
		alReX32[i] /= 4;
		alImX32[i] /= 4;
	}
			
	inv_fft32(alReX32,alImX32);

	printf("\n\rOutput INV FFT signal 32 bits \n\r\n\r");
	
	for(i = 0; i < N; i++)
	{		
		alReX32[i] *= 4;  /* Restore the signal with initial values */
		printf("%d\n\r",alReX32[i]);
	}
		
	#endif  /*bits32*/
	
	#ifdef bits16    /* FFT in eMAC 16 bits */

	printf("\n\r\n\rInput signal 16 bits \n\r\n\r");
	
	for(i = 0; i < N; i++)
	{
		alReX16[i] = FRAC16(afInput[i]);
		printf("%d \n\r",alReX16[i]);
		alReX16[i] /= (N/2);   /* This operation is needed because the output is N/2 bigger */
	}

	
	printf("\n\rOutput FFT signal 16 bits \n\r\n\r");

	fft16(alReX16,alImX16);

	for(i = 0; i < N/2; i++)
	{
		/* Restore the values of the signal */
		alReX16[i] *= 2;
		alImX16[i] *= 2;
		printf("%d \t %d\n\r",alReX16[i],alImX16[i]);

	}
	
	for(i = 0; i < N/2; i++)
	{
		/* Reduce the FFT result */
		alReX16[i] /= 2;
		alImX16[i] /= 2;

	}
	
	
	inv_fft16(alReX16,alImX16);
	
	printf("\n\rOutput INV FFT signal 16 bits \n\r\n\r");

	for(i = 0; i < N; i++)
	{
		alReX16[i] *= 2; /* Restore the FFT result */
		printf("%d\n\r",alReX16[i]);
	}
		
	#endif /*bits16*/
	
		
	
	while(1);	// Idle
	
	return 0;
	
}